/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.animfix.stitching;

import com.falsepattern.animfix.stitching.HolderSlot;
import com.falsepattern.animfix.stitching.Rect2D;
import com.falsepattern.animfix.stitching.SpriteSlot;
import com.falsepattern.animfix.stitching.StitcherState;
import com.falsepattern.animfix.stitching.TooBigException;
import com.falsepattern.animfix.stitching.packing2d.Algorithm;
import com.falsepattern.animfix.stitching.packing2d.Packer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.Stitcher;

public class TurboStitcher
extends SpriteSlot {
    private final int maxWidth;
    private final int maxHeight;
    private final boolean forcePowerOf2;
    private List<SpriteSlot> slots = new ArrayList<SpriteSlot>();
    private StitcherState state = StitcherState.SETUP;

    private static int nextPowerOfTwo(int number) {
        --number;
        number |= number >>> 1;
        number |= number >>> 2;
        number |= number >>> 4;
        number |= number >>> 8;
        number |= number >>> 16;
        return ++number;
    }

    public void addSprite(Stitcher.Holder holder) {
        this.addSprite(new HolderSlot(holder));
    }

    public void addSprite(SpriteSlot rect) {
        this.verifyState(StitcherState.SETUP);
        this.slots.add(rect);
    }

    public void reset() {
        this.slots = new ArrayList<SpriteSlot>();
        this.state = StitcherState.SETUP;
    }

    public void stitch() throws TooBigException {
        List<SpriteSlot> packedSlots;
        this.verifyState(StitcherState.SETUP);
        this.width = 0;
        this.height = 0;
        if (this.slots.size() == 0) {
            this.state = StitcherState.STITCHED;
            return;
        }
        for (SpriteSlot slot : this.slots) {
            this.width = Math.max(this.width, slot.width);
        }
        if (this.forcePowerOf2) {
            this.width = TurboStitcher.nextPowerOfTwo(this.width);
        }
        if (this.width > this.maxWidth) {
            throw new TooBigException();
        }
        this.width = Math.max(this.width >>> 1, 1);
        do {
            if (this.width == this.maxWidth) {
                throw new TooBigException();
            }
            this.width = this.forcePowerOf2 ? (this.width *= 2) : (this.width += Math.min(this.width, 16));
            if (this.width > this.maxWidth) {
                this.width = this.maxWidth;
            }
            packedSlots = Packer.pack(this.slots, Algorithm.FIRST_FIT_DECREASING_HEIGHT, this.width);
            this.height = 0;
            for (SpriteSlot sprite : packedSlots) {
                this.height = Math.max(this.height, sprite.y + sprite.height);
            }
            if (!this.forcePowerOf2) continue;
            this.height = TurboStitcher.nextPowerOfTwo(this.height);
        } while (this.height > this.maxHeight || this.height > this.width);
        this.slots = packedSlots;
        this.state = StitcherState.STITCHED;
    }

    public List<Stitcher.Slot> getSlots() {
        return this.getSlots(new Rect2D());
    }

    @Override
    public List<Stitcher.Slot> getSlots(Rect2D parent) {
        this.verifyState(StitcherState.STITCHED);
        ArrayList<Stitcher.Slot> mineSlots = new ArrayList<Stitcher.Slot>();
        Rect2D offset = new Rect2D(this.x + parent.x, this.y + parent.y, this.width, this.height);
        for (SpriteSlot slot : this.slots) {
            mineSlots.addAll(slot.getSlots(offset));
        }
        return mineSlots;
    }

    private void verifyState(StitcherState ... allowedStates) {
        boolean ok = false;
        for (StitcherState state : allowedStates) {
            if (state != this.state) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalStateException("Cold not execute operation: invalid state");
        }
    }

    public TurboStitcher(int maxWidth, int maxHeight, boolean forcePowerOf2) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.forcePowerOf2 = forcePowerOf2;
    }

    public StitcherState getState() {
        return this.state;
    }
}

