/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.animfix.mixin.mixins.client.minecraft;

import com.falsepattern.animfix.AnimationUpdateBatcher;
import com.falsepattern.animfix.interfaces.ITextureMapMixin;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.profiler.Profiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextureMap.class})
public abstract class TextureMapMixin
implements ITextureMapMixin {
    private static Profiler theProfiler;
    @Shadow
    private int field_147636_j;
    @Shadow
    @Final
    private String field_94254_c;
    private AnimationUpdateBatcher batcher;

    @Inject(method={"loadTexture"}, at={@At(value="HEAD")}, require=1)
    private void setupBatcher(CallbackInfo ci) {
        AnimationUpdateBatcher.currentAtlas = (TextureMap)this;
        AnimationUpdateBatcher.currentName = this.field_94254_c;
    }

    @Inject(method={"loadTexture"}, at={@At(value="RETURN")}, require=1)
    private void finishSetup(CallbackInfo ci) {
        AnimationUpdateBatcher.currentAtlas = null;
        AnimationUpdateBatcher.currentName = null;
    }

    @Redirect(method={"loadTextureAtlas"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0), require=1)
    private boolean storeAnimatedInBatch(List<TextureAtlasSprite> listAnimatedSprites, Object obj) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)obj;
        listAnimatedSprites.add(sprite);
        AnimationUpdateBatcher.batcher = this.batcher;
        TextureUtil.func_147955_a((int[][])sprite.func_147965_a(0), (int)sprite.func_94211_a(), (int)sprite.func_94216_b(), (int)sprite.func_130010_a(), (int)sprite.func_110967_i(), (boolean)false, (boolean)false);
        AnimationUpdateBatcher.batcher = null;
        return true;
    }

    @Inject(method={"updateAnimations"}, at={@At(value="HEAD")}, require=1)
    private void beginBatchAnimations(CallbackInfo ci) {
        if (theProfiler == null) {
            theProfiler = Minecraft.func_71410_x().field_71424_I;
        }
        theProfiler.func_76320_a("updateAnimations");
        AnimationUpdateBatcher.batcher = this.batcher;
    }

    @Inject(method={"updateAnimations"}, at={@At(value="RETURN")}, require=1)
    private void flushBatchAnimations(CallbackInfo ci) {
        AnimationUpdateBatcher.batcher = null;
        if (this.batcher != null) {
            theProfiler.func_76320_a("uploadBatch");
            this.batcher.upload();
            theProfiler.func_76319_b();
        }
        theProfiler.func_76319_b();
    }

    @Override
    public void initializeBatcher(int xOffset, int yOffset, int width, int height) {
        if (this.batcher != null) {
            this.batcher.terminate();
        }
        this.batcher = new AnimationUpdateBatcher(xOffset, yOffset, width, height, this.field_147636_j);
    }
}

