/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.animfix.mixin.mixins.client.minecraft;

import com.falsepattern.animfix.AnimationUpdateBatcher;
import com.falsepattern.animfix.interfaces.ITextureMapMixin;
import com.falsepattern.animfix.stitching.TooBigException;
import com.falsepattern.animfix.stitching.TurboStitcher;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Stitcher.class})
public abstract class StitcherMixin {
    @Shadow
    @Final
    private List<Stitcher.Slot> field_94317_b;
    @Shadow
    private int field_94315_d;
    @Shadow
    private int field_94318_c;
    private TurboStitcher masterStitcher;
    private TurboStitcher batchingStitcher;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void initTurbo(int maxWidth, int maxHeight, boolean forcePowerOf2, int maxTileDimension, int mipmapLevelStitcher, CallbackInfo ci) {
        this.masterStitcher = new TurboStitcher(maxWidth, maxHeight, forcePowerOf2);
        this.batchingStitcher = new TurboStitcher(maxWidth, maxHeight, false);
        this.masterStitcher.addSprite(this.batchingStitcher);
    }

    @Redirect(method={"addSprite"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z"), require=1)
    private boolean hijackAdd(Set<Stitcher.Holder> instance, Object e) {
        Stitcher.Holder holder = (Stitcher.Holder)e;
        TextureAtlasSprite sprite = holder.func_98150_a();
        if (sprite.func_130098_m() || sprite.func_110970_k() > 1) {
            this.batchingStitcher.addSprite(holder);
        } else {
            this.masterStitcher.addSprite((Stitcher.Holder)e);
        }
        return true;
    }

    @Inject(method={"doStitch"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void doTurboStitch(CallbackInfo ci) {
        ci.cancel();
        try {
            this.batchingStitcher.stitch();
            this.masterStitcher.stitch();
            this.field_94318_c = this.masterStitcher.width;
            this.field_94315_d = this.masterStitcher.height;
            this.field_94317_b.clear();
            this.field_94317_b.addAll(this.masterStitcher.getSlots());
            ((ITextureMapMixin)AnimationUpdateBatcher.currentAtlas).initializeBatcher(this.batchingStitcher.x, this.batchingStitcher.y, this.batchingStitcher.width, this.batchingStitcher.height);
        }
        catch (TooBigException ignored) {
            throw new StitcherException(null, "Unable to fit all textures into atlas. Maybe try a lower resolution resourcepack?");
        }
        finally {
            this.masterStitcher.reset();
            this.batchingStitcher.reset();
            this.masterStitcher.addSprite(this.batchingStitcher);
        }
    }
}

