/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.animfix;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import org.lwjgl.opengl.GL11;

public class AnimationUpdateBatcher {
    public static TextureMap currentAtlas = null;
    public static AnimationUpdateBatcher batcher = null;
    public static String currentName = null;
    private final int mipLevels;
    private final int xOffset;
    private final int yOffset;
    private final int width;
    private final int height;
    private final int[] offsets;
    private final IntBuffer memory;
    private final List<int[][]> queuedTextures1 = new ArrayList<int[][]>();
    private final List<int[]> queuedDimensions1 = new ArrayList<int[]>();
    private final List<int[][]> queuedTextures2 = new ArrayList<int[][]>();
    private final List<int[]> queuedDimensions2 = new ArrayList<int[]>();
    private final AtomicInteger queuedCount1 = new AtomicInteger(0);
    private final AtomicInteger queuedCount2 = new AtomicInteger(0);
    private final Semaphore batchingSemaphore = new Semaphore(0);
    private final Semaphore uploadingSemaphore = new Semaphore(1);
    private final Thread thread;
    private final AtomicBoolean flipped = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(true);

    public AnimationUpdateBatcher(int xOffset, int yOffset, int width, int height, int mipLevel) {
        this.mipLevels = mipLevel;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.width = width;
        this.height = height;
        this.offsets = new int[mipLevel + 1];
        int size = 0;
        for (int i = 0; i <= mipLevel; ++i) {
            this.offsets[i] = size;
            size += (width >>> i) * (height >>> i);
        }
        this.memory = GLAllocation.func_74527_f((int)size);
        this.thread = new Thread(this::run);
        this.thread.setName("AnimFix batch thread (" + currentName + ")");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean scheduleUpload(int[][] texture, int width, int height, int xOffset, int yOffset) {
        List<int[]> dimList;
        if ((xOffset -= this.xOffset) < 0 || xOffset >= this.width || (yOffset -= this.yOffset) < 0 || yOffset >= this.height) {
            return false;
        }
        boolean f = this.flipped.get();
        int i = (f ? this.queuedCount2 : this.queuedCount1).getAndIncrement();
        List<int[]> list = dimList = f ? this.queuedDimensions2 : this.queuedDimensions1;
        while (dimList.size() <= i) {
            dimList.add(new int[4]);
        }
        int[] dims = dimList.get(i);
        dims[0] = width;
        dims[1] = height;
        dims[2] = xOffset;
        dims[3] = yOffset;
        (f ? this.queuedTextures2 : this.queuedTextures1).add(texture);
        return true;
    }

    public void terminate() {
        this.running.set(false);
        this.thread.interrupt();
    }

    private void run() {
        while (this.running.get()) {
            List<int[][]> tfb;
            try {
                this.batchingSemaphore.acquire();
            }
            catch (InterruptedException ignored) {
                continue;
            }
            boolean f = this.flipped.get();
            List<int[]> dfb = f ? this.queuedDimensions1 : this.queuedDimensions2;
            List<int[][]> list = tfb = f ? this.queuedTextures1 : this.queuedTextures2;
            for (int i = (f ? this.queuedCount1 : this.queuedCount2).get() - 1; i >= 0; --i) {
                this.batchUpload(dfb.get(i), tfb.remove(i));
            }
            (f ? this.queuedCount1 : this.queuedCount2).set(0);
            this.flipped.set(!this.flipped.get());
            this.uploadingSemaphore.release();
        }
    }

    private void batchUpload(int[] dims, int[][] texture) {
        int width = dims[0];
        int height = dims[1];
        int xOffset = dims[2];
        int yOffset = dims[3];
        int w = this.width;
        for (int mipMapLevel = 0; mipMapLevel < texture.length; ++mipMapLevel) {
            int base = this.offsets[mipMapLevel] + yOffset * w + xOffset;
            for (int i = 0; i < height; ++i) {
                this.memory.position(base + i * w);
                this.memory.put(texture[mipMapLevel], i * width, width);
            }
            xOffset >>>= 1;
            yOffset >>>= 1;
            width >>>= 1;
            height >>>= 1;
            w >>>= 1;
        }
    }

    public void upload() {
        while (!this.uploadingSemaphore.tryAcquire()) {
            Thread.yield();
        }
        for (int i = 0; i <= this.mipLevels; ++i) {
            this.memory.position(this.offsets[i]);
            GL11.glTexSubImage2D((int)3553, (int)i, (int)(this.xOffset >>> i), (int)(this.yOffset >>> i), (int)(this.width >>> i), (int)(this.height >>> i), (int)32993, (int)33639, (IntBuffer)this.memory);
        }
        this.batchingSemaphore.release();
    }
}

