/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.asmc.version;

import astrotibs.asmc.ModASMC;
import astrotibs.asmc.config.GeneralConfig;
import astrotibs.asmc.utility.LogHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.InputStream;
import java.net.URL;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.io.IOUtils;

public class VersionChecker
implements Runnable {
    private static boolean isLatestVersion = false;
    private static boolean warnaboutfailure = false;
    private static String latestVersion = "";

    @Override
    public void run() {
        InputStream in = null;
        try {
            in = new URL("https://gitgud.io/AstroTibs/asmc/raw/1.7.10/CURRENT_VERSION").openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            latestVersion = (String)IOUtils.readLines(in).get(0);
        }
        catch (Exception e) {
            if (!warnaboutfailure) {
                LogHelper.error("Could not connect with server to compare ASMC version");
                LogHelper.error("You can check for new versions at https://www.curseforge.com/minecraft/mc-mods/asmc");
                warnaboutfailure = true;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        isLatestVersion = "1.0.2".equals(latestVersion);
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            LogHelper.info("This version of ASMC (1.0.2) differs from the latest version: " + latestVersion);
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END && event.player.field_70173_aa <= 50 && event.player.field_70173_aa % 10 == 0) {
            if ((latestVersion.equals(null) || latestVersion.equals("")) && !warnaboutfailure) {
                this.run();
            }
            if (!(ModASMC.haveWarnedVersionOutOfDate || !GeneralConfig.versionChecker || ModASMC.versionChecker.isLatestVersion() || latestVersion.equals(null) || latestVersion.equals("") || "1.0.2".contains("DEV"))) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.LIGHT_PURPLE + "ASMC" + EnumChatFormatting.RESET + " version " + EnumChatFormatting.GREEN + this.getLatestVersion() + EnumChatFormatting.RESET + " is available! Get it at:"));
                event.player.func_146105_b(ForgeHooks.newChatWithLinks((String)"https://www.curseforge.com/minecraft/mc-mods/asmc"));
                ModASMC.haveWarnedVersionOutOfDate = true;
            }
        }
    }
}

