/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import yalter.mousetweaks.DeobfuscationLayer;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Reflection;
import yalter.mousetweaks.api.IMTModGuiContainer;

public class ModCompatibility
extends DeobfuscationLayer {
    private static boolean initialized = false;
    private static boolean forestryInstalled = false;
    private static boolean codechickencoreInstalled = false;
    private static boolean NEIInstalled = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        forestryInstalled = Reflection.reflectForestry();
        if (forestryInstalled) {
            Logger.Log("Successfully reflected Forestry!");
        }
        if (codechickencoreInstalled = Reflection.reflectCodeChickenCore()) {
            Logger.Log("Successfully reflected CodeChickenCore!");
        }
        if (NEIInstalled = Reflection.reflectNEI()) {
            Logger.Log("Successfully reflected NEI!");
        }
        initialized = true;
    }

    public static int getModGuiContainerID(bdw guiScreen) {
        if (guiScreen instanceof IMTModGuiContainer) {
            return 2;
        }
        if (forestryInstalled && Reflection.forestry.isInstance("GuiForestry", guiScreen)) {
            return 3;
        }
        if (codechickencoreInstalled && Reflection.codechickencore.isInstance("GuiContainerWidget", guiScreen)) {
            return 4;
        }
        if (NEIInstalled && Reflection.NEI.isInstance("GuiRecipe", guiScreen) || Reflection.NEI.isInstance("GuiEnchantmentModifier", guiScreen)) {
            return 5;
        }
        return 0;
    }

    public static String getModNameFromModGuiContainerID(int id, bdw guiScreen) {
        switch (id) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).getModName();
            }
            case 3: {
                return "Forestry";
            }
            case 4: {
                return "CodeChickenCore";
            }
            case 5: {
                return "NotEnoughItems";
            }
        }
        return "Unknown";
    }

    public static boolean isWheelDisabledForThisModContainer(int modGuiContainerID, bdw guiScreen) {
        switch (modGuiContainerID) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).isWheelTweakDisabled();
            }
        }
        return false;
    }

    public static aay modGetSlot(int modGuiContainerID, bdw guiScreen, Object modContainer, int slotNumber) {
        switch (modGuiContainerID) {
            case 2: {
                return ModCompatibility.asSlot(((IMTModGuiContainer)guiScreen).getModSlot(modContainer, slotNumber));
            }
            case 3: {
                return ModCompatibility.getSlot(ModCompatibility.asContainer(modContainer), slotNumber);
            }
            case 5: {
                return ModCompatibility.getSlot(ModCompatibility.asContainer(modContainer), slotNumber);
            }
        }
        return null;
    }

    public static boolean modIsCraftingOutputSlot(int modGuiContainerID, bdw guiScreen, Object modContainer, aay selectedSlot) {
        switch (modGuiContainerID) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).isCraftingOutputSlot(modContainer, selectedSlot);
            }
            case 3: {
                return Reflection.is(modContainer, "ContainerSqueezer") && (ModCompatibility.getSlotNumber(selectedSlot) == 9 || ModCompatibility.getSlotNumber(selectedSlot) == 11) || Reflection.is(modContainer, "ContainerMoistener") && ModCompatibility.getSlotNumber(selectedSlot) == 9 || Reflection.is(modContainer, "ContainerCentrifuge") && ModCompatibility.getSlotNumber(selectedSlot) >= 1 && ModCompatibility.getSlotNumber(selectedSlot) <= 9 || Reflection.is(modContainer, "ContainerCarpenter") && ModCompatibility.getSlotNumber(selectedSlot) == 21 || Reflection.is(modContainer, "ContainerFabricator") && ModCompatibility.getSlotNumber(selectedSlot) == 20 || Reflection.is(modContainer, "ContainerWorktable") && ModCompatibility.getSlotNumber(selectedSlot) == 27;
            }
        }
        return false;
    }

    public static void modClickSlot(int modGuiContainerID, bdw guiScreen, Object modContainer, aay targetSlot, int mouseButton, boolean shiftPressed) {
        switch (modGuiContainerID) {
            case 2: {
                ((IMTModGuiContainer)guiScreen).clickModSlot(modContainer, targetSlot, mouseButton, shiftPressed);
                return;
            }
            case 3: {
                Reflection.forestry.invokeMethod(guiScreen, "handleMouseClick", targetSlot, 0, mouseButton, shiftPressed ? 1 : 0);
                return;
            }
            case 5: {
                ModCompatibility.windowClick(ModCompatibility.getWindowId(ModCompatibility.asContainer(modContainer)), ModCompatibility.getSlotNumber(targetSlot), mouseButton, shiftPressed ? 1 : 0);
                return;
            }
        }
    }

    public static aay getModSelectedSlot(int modGuiContainerID, bdw guiScreen, Object modContainer, int slotCount) {
        switch (modGuiContainerID) {
            case 2: {
                return ModCompatibility.asSlot(((IMTModGuiContainer)guiScreen).getModSelectedSlot(modContainer, slotCount));
            }
            case 3: {
                return ModCompatibility.asSlot(Reflection.forestry.invokeMethod(guiScreen, "getSlotAtPosition", ModCompatibility.getRequiredMouseX(), ModCompatibility.getRequiredMouseY()));
            }
            case 5: {
                return ModCompatibility.getSelectedSlot(ModCompatibility.asGuiContainer(guiScreen), ModCompatibility.asContainer(modContainer), slotCount);
            }
        }
        return null;
    }

    public static int getModSlotCount(int modGuiContainerID, bdw guiScreen, Object modContainer) {
        switch (modGuiContainerID) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).getModSlotCount(modContainer);
            }
            case 3: {
                return ModCompatibility.getSlots(ModCompatibility.asContainer(modContainer)).size();
            }
            case 5: {
                return ModCompatibility.getSlots(ModCompatibility.asContainer(modContainer)).size();
            }
        }
        return 0;
    }

    public static Object getModContainer(int modGuiContainerID, bdw guiScreen) {
        switch (modGuiContainerID) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).getModContainer();
            }
            case 3: {
                return Reflection.forestry.getFieldValue("inventorySlots", guiScreen);
            }
            case 5: {
                return ModCompatibility.getContainer(ModCompatibility.asGuiContainer(guiScreen));
            }
        }
        return null;
    }

    public static void disableRMBDragIfRequired(int guiContainerID, bdw guiScreen, Object modContainer, aay firstSlot, boolean shouldClick) {
        switch (guiContainerID) {
            case 2: {
                ((IMTModGuiContainer)guiScreen).disableRMBDragIfRequired(modContainer, firstSlot, shouldClick);
                return;
            }
            case 5: {
                ModCompatibility.disableVanillaRMBDrag(ModCompatibility.asGuiContainer(guiScreen));
                if (shouldClick) {
                    ModCompatibility.modClickSlot(guiContainerID, guiScreen, modContainer, firstSlot, 1, false);
                }
                return;
            }
        }
    }

    public static boolean isDisabledForThisModContainer(int guiContainerID, bdw guiScreen, Object container) {
        switch (guiContainerID) {
            case 2: {
                return ((IMTModGuiContainer)guiScreen).isMouseTweaksDisabled();
            }
            case 4: {
                return true;
            }
            case 5: {
                return !Reflection.NEI.isInstance("GuiEnchantmentModifier", guiScreen);
            }
        }
        return false;
    }
}

