/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.threadedupdates;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.shader.TesselatorVertexState;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.occlusion.IRenderGlobal;
import org.embeddedt.archaicfix.occlusion.IRenderGlobalListener;
import org.embeddedt.archaicfix.occlusion.IRendererUpdateOrderProvider;
import org.embeddedt.archaicfix.threadedupdates.ICapturableTessellator;
import org.embeddedt.archaicfix.threadedupdates.IRendererUpdateResultHolder;

public class ThreadedChunkUpdateHelper
implements IRenderGlobalListener {
    public static ThreadedChunkUpdateHelper instance;
    public static Thread MAIN_THREAD;
    private static final boolean DEBUG_THREADED_UPDATE_FINE_LOG;
    public static WorldRenderer lastWorldRenderer;
    public BlockingQueue<WorldRenderer> taskQueue = new LinkedBlockingDeque<WorldRenderer>();
    public BlockingDeque<WorldRenderer> finishedTasks = new LinkedBlockingDeque<WorldRenderer>();
    public Queue<WorldRenderer> urgentTaskQueue = new ArrayDeque<WorldRenderer>();
    public ThreadLocal<Tessellator> threadTessellator = ThreadLocal.withInitial(Tessellator::new);
    IRendererUpdateOrderProvider rendererUpdateOrderProvider = new IRendererUpdateOrderProvider(){
        private List<WorldRenderer> updatedRenderers = new ArrayList<WorldRenderer>();
        private WorldRenderer nextRenderer;

        @Override
        public void prepare(List<WorldRenderer> worldRenderersToUpdateList) {
            ThreadedChunkUpdateHelper.this.preRendererUpdates(worldRenderersToUpdateList);
        }

        @Override
        public boolean hasNext(List<WorldRenderer> worldRenderersToUpdateList) {
            WorldRenderer wr;
            if (!ThreadedChunkUpdateHelper.this.urgentTaskQueue.isEmpty()) {
                this.nextRenderer = ThreadedChunkUpdateHelper.this.urgentTaskQueue.poll();
                UpdateTask task = ((IRendererUpdateResultHolder)this.nextRenderer).arch$getRendererUpdateTask();
                task.cancelled = true;
                return true;
            }
            while ((wr = ThreadedChunkUpdateHelper.this.finishedTasks.poll()) != null) {
                UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
                if (task.cancelled || !wr.field_78939_q) {
                    task.clear();
                    continue;
                }
                this.nextRenderer = wr;
                return true;
            }
            return false;
        }

        @Override
        public WorldRenderer next(List<WorldRenderer> worldRenderersToUpdateList) {
            Preconditions.checkNotNull((Object)this.nextRenderer);
            WorldRenderer wr = this.nextRenderer;
            this.nextRenderer = null;
            this.updatedRenderers.add(wr);
            ThreadedChunkUpdateHelper.debugLog("Consuming renderer " + ThreadedChunkUpdateHelper.worldRendererToString(wr) + " " + ThreadedChunkUpdateHelper.worldRendererUpdateTaskToString(wr));
            return wr;
        }

        @Override
        public void cleanup(List<WorldRenderer> worldRenderersToUpdateList) {
            for (WorldRenderer wr : this.updatedRenderers) {
                worldRenderersToUpdateList.remove(wr);
                ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask().clear();
            }
            this.updatedRenderers.clear();
            ThreadedChunkUpdateHelper.this.urgentTaskQueue.clear();
            this.nextRenderer = null;
        }
    };

    public void init() {
        ((IRenderGlobal)Minecraft.func_71410_x().field_71438_f).arch$setRendererUpdateOrderProvider(this.rendererUpdateOrderProvider);
        ((IRenderGlobal)Minecraft.func_71410_x().field_71438_f).arch$addRenderGlobalListener(this);
        MAIN_THREAD = Thread.currentThread();
        for (int i = 0; i < 1; ++i) {
            new Thread(this::runThread, "Chunk Update Worker Thread #" + i).start();
        }
    }

    private void preRendererUpdates(List<WorldRenderer> toUpdateList) {
        this.updateWorkQueue(toUpdateList);
        this.removeCancelledResults();
    }

    private void updateWorkQueue(List<WorldRenderer> toUpdateList) {
        int updateQueueSize = 64;
        this.taskQueue.clear();
        for (int i = 0; i < 64 && i < toUpdateList.size(); ++i) {
            WorldRenderer wr = toUpdateList.get(i);
            UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
            if (wr.func_78912_a((Entity)Minecraft.func_71410_x().field_71451_h) < 256.0f) {
                if (!ArchaicConfig.disableBlockingChunkUpdates) {
                    this.urgentTaskQueue.add(wr);
                } else {
                    task.important = true;
                }
            }
            if (!task.isEmpty()) continue;
            ThreadedChunkUpdateHelper.debugLog("Adding " + ThreadedChunkUpdateHelper.worldRendererToString(wr) + " to task queue");
            task.chunkCache = this.getChunkCacheSnapshot(wr);
            this.taskQueue.add(wr);
        }
    }

    private void removeCancelledResults() {
        Iterator<WorldRenderer> it = this.finishedTasks.iterator();
        while (it.hasNext()) {
            WorldRenderer wr = it.next();
            UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
            if (!task.cancelled) continue;
            task.clear();
            it.remove();
        }
    }

    @Override
    public void onDirtyRendererChanged(WorldRenderer wr) {
        this.onWorldRendererDirty(wr);
    }

    public void onWorldRendererDirty(WorldRenderer wr) {
        UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
        if (!task.isEmpty()) {
            ThreadedChunkUpdateHelper.debugLog("Renderer " + ThreadedChunkUpdateHelper.worldRendererToString(wr) + " is dirty, cancelling task");
            task.cancelled = true;
        }
    }

    private void runThread() {
        while (true) {
            WorldRenderer wr = this.taskQueue.take();
            UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
            task.started = true;
            try {
                this.doChunkUpdate(wr);
            }
            catch (Exception e) {
                ArchaicLogger.LOGGER.error("Failed to update chunk " + ThreadedChunkUpdateHelper.worldRendererToString(wr));
                e.printStackTrace();
                for (UpdateTask.Result r : task.result) {
                    r.clear();
                }
                ((ICapturableTessellator)this.threadTessellator.get()).discard();
            }
            if (!task.important) {
                this.finishedTasks.add(wr);
                continue;
            }
            this.finishedTasks.addFirst(wr);
        }
    }

    public void doChunkUpdate(WorldRenderer wr) {
        ThreadedChunkUpdateHelper.debugLog("Starting update of renderer " + ThreadedChunkUpdateHelper.worldRendererToString(wr));
        UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
        ChunkCache chunkcache = task.chunkCache;
        Tessellator tess = this.threadTessellator.get();
        if (chunkcache != null && !chunkcache.func_72806_N()) {
            RenderBlocks renderblocks = new RenderBlocks((IBlockAccess)chunkcache);
            for (int pass = 0; pass < 2; ++pass) {
                boolean renderedSomething = false;
                boolean startedTessellator = false;
                block1: for (int y = wr.field_78920_d; y < wr.field_78920_d + 16; ++y) {
                    for (int z = wr.field_78921_e; z < wr.field_78921_e + 16; ++z) {
                        for (int x = wr.field_78923_c; x < wr.field_78923_c + 16; ++x) {
                            if (task.cancelled) {
                                ThreadedChunkUpdateHelper.debugLog("Realized renderer " + ThreadedChunkUpdateHelper.worldRendererToString(wr) + " is dirty, aborting update");
                                break block1;
                            }
                            Block block = chunkcache.func_147439_a(x, y, z);
                            if (block.func_149688_o() == Material.field_151579_a) continue;
                            if (!startedTessellator) {
                                startedTessellator = true;
                                tess.func_78382_b();
                                tess.func_78373_b((double)(-wr.field_78923_c), (double)(-wr.field_78920_d), (double)(-wr.field_78921_e));
                            }
                            int k3 = block.func_149701_w();
                            if (!block.canRenderInPass(pass)) continue;
                            renderedSomething |= renderblocks.func_147805_b(block, x, y, z);
                        }
                    }
                }
                if (startedTessellator) {
                    task.result[pass].renderedQuads = ((ICapturableTessellator)tess).arch$getUnsortedVertexState();
                    ((ICapturableTessellator)tess).discard();
                }
                task.result[pass].renderedSomething = renderedSomething;
            }
        }
        ThreadedChunkUpdateHelper.debugLog("Result of updating " + ThreadedChunkUpdateHelper.worldRendererToString(wr) + ": " + ThreadedChunkUpdateHelper.worldRendererUpdateTaskToString(wr));
    }

    public static boolean canBlockBeRenderedOffThread(Block block, int pass, int renderType) {
        return renderType < 42 && renderType != 22;
    }

    private ChunkCache getChunkCacheSnapshot(WorldRenderer wr) {
        int pad = 1;
        ChunkCache chunkcache = new ChunkCache(wr.field_78924_a, wr.field_78923_c - pad, wr.field_78920_d - pad, wr.field_78921_e - pad, wr.field_78923_c + 16 + pad, wr.field_78920_d + 16 + pad, wr.field_78921_e + 16 + pad, pad);
        return chunkcache;
    }

    public void clear() {
    }

    public Tessellator getThreadTessellator() {
        if (Thread.currentThread() == MAIN_THREAD) {
            return Tessellator.field_78398_a;
        }
        return this.threadTessellator.get();
    }

    private static String worldRendererToString(WorldRenderer wr) {
        return wr + "(" + wr.field_78923_c + ", " + wr.field_78920_d + ", " + wr.field_78921_e + ")";
    }

    private static String worldRendererUpdateTaskToString(WorldRenderer wr) {
        UpdateTask task = ((IRendererUpdateResultHolder)wr).arch$getRendererUpdateTask();
        return task.result[0].renderedSomething + " (" + (task.result[0].renderedQuads == null ? "null" : Integer.valueOf(task.result[0].renderedQuads.func_147575_c())) + ")/" + task.result[1].renderedSomething + " (" + (task.result[1].renderedQuads == null ? "null" : Integer.valueOf(task.result[1].renderedQuads.func_147575_c())) + ")";
    }

    private static void debugLog(String msg) {
        if (DEBUG_THREADED_UPDATE_FINE_LOG) {
            ArchaicLogger.LOGGER.trace(msg);
        }
    }

    static {
        DEBUG_THREADED_UPDATE_FINE_LOG = Boolean.parseBoolean(System.getProperty("archaicfix.debug.enableThreadedUpdateFineLog"));
    }

    public static class UpdateTask {
        public boolean started;
        public boolean cancelled;
        public boolean important;
        public Result[] result = new Result[]{new Result(), new Result()};
        public ChunkCache chunkCache;

        public boolean isEmpty() {
            return !this.started;
        }

        public void clear() {
            this.started = false;
            this.chunkCache = null;
            for (Result r : this.result) {
                r.clear();
            }
            this.cancelled = false;
            this.important = false;
        }

        public static class Result {
            public boolean renderedSomething;
            public TesselatorVertexState renderedQuads;

            public void clear() {
                this.renderedSomething = false;
                this.renderedQuads = null;
            }
        }
    }
}

