/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.ducks.ILazyChunkProviderServer;
import org.embeddedt.archaicfix.helpers.ChunkQueueSorter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkProviderServer.class})
public abstract class MixinChunkProviderServer
implements ILazyChunkProviderServer {
    @Shadow
    public WorldServer field_73251_h;
    private ObjectOpenHashSet<Pair<ChunkCoordIntPair, Runnable>> chunksToLoadSlow = new ObjectOpenHashSet();
    private ArrayList<Pair<ChunkCoordIntPair, Runnable>> chunksToLoadSlowQueue = new ArrayList();
    private ObjectOpenHashSet<Pair<ChunkCoordIntPair, Runnable>> chunksToLoadDropQueue = new ObjectOpenHashSet();

    @Shadow(remap=false)
    public abstract Chunk originalLoadChunk(int var1, int var2);

    @Redirect(method={"unloadChunksIfNotNearSpawn"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/DimensionManager;shouldLoadSpawn(I)Z", remap=false))
    private boolean neverLoadSpawn(int dim) {
        return !ArchaicConfig.disableSpawnChunks && DimensionManager.shouldLoadSpawn((int)dim);
    }

    @Redirect(method={"originalLoadChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunkProvider;provideChunk(II)Lnet/minecraft/world/chunk/Chunk;", remap=true), remap=false)
    private Chunk populateChunkWithBiomes(IChunkProvider instance, int chunkX, int chunkZ) {
        Chunk chunk = instance.func_73154_d(chunkX, chunkZ);
        if (chunk != null) {
            WorldChunkManager manager = chunk.field_76637_e.func_72959_q();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    chunk.func_76591_a(x, z, manager);
                }
            }
        }
        return chunk;
    }

    @Inject(method={"loadChunk(IILjava/lang/Runnable;)Lnet/minecraft/world/chunk/Chunk;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;originalLoadChunk(II)Lnet/minecraft/world/chunk/Chunk;", remap=false)}, cancellable=true, remap=false)
    private void queueChunkGeneration(int chunkX, int chunkZ, Runnable runnable, CallbackInfoReturnable<Chunk> cir) {
        if (ArchaicConfig.lazyChunkLoading && runnable != null) {
            cir.setReturnValue(null);
            ChunkCoordIntPair c = new ChunkCoordIntPair(chunkX, chunkZ);
            Pair pair = Pair.of((Object)c, (Object)runnable);
            if (!this.chunksToLoadSlow.contains((Object)pair)) {
                this.chunksToLoadSlow.add((Object)pair);
                this.chunksToLoadSlowQueue.add((Pair<ChunkCoordIntPair, Runnable>)pair);
            }
        }
    }

    @Inject(method={"unloadQueuedChunks"}, at={@At(value="RETURN")})
    private void loadLazyChunks(CallbackInfoReturnable<Boolean> cir) {
        if (!ArchaicConfig.lazyChunkLoading) {
            return;
        }
        Profiler profiler = this.field_73251_h.field_72984_F;
        profiler.func_76320_a("lazychunks");
        if (this.chunksToLoadDropQueue.size() > 0) {
            profiler.func_76320_a("drop");
            this.chunksToLoadSlowQueue.removeIf(k -> this.chunksToLoadDropQueue.contains(k));
            this.chunksToLoadSlow.removeAll(this.chunksToLoadDropQueue);
            this.chunksToLoadDropQueue.clear();
            profiler.func_76319_b();
        }
        if (this.chunksToLoadSlowQueue.size() > 0) {
            int i;
            profiler.func_76320_a("sort");
            if (this.field_73251_h.field_73010_i.size() > 0) {
                ChunkCoordIntPair[] playerChunks = new ChunkCoordIntPair[this.field_73251_h.field_73010_i.size()];
                for (int i2 = 0; i2 < this.field_73251_h.field_73010_i.size(); ++i2) {
                    EntityPlayer player = (EntityPlayer)this.field_73251_h.field_73010_i.get(i2);
                    playerChunks[i2] = new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj);
                }
                this.chunksToLoadSlowQueue.sort(new ChunkQueueSorter(playerChunks));
            }
            profiler.func_76318_c("load");
            int amount = Math.min(5, this.chunksToLoadSlowQueue.size());
            for (i = 0; i < amount; ++i) {
                Pair<ChunkCoordIntPair, Runnable> chunkPair = this.chunksToLoadSlowQueue.get(i);
                this.chunksToLoadSlow.remove(chunkPair);
                this.originalLoadChunk(((ChunkCoordIntPair)chunkPair.getLeft()).field_77276_a, ((ChunkCoordIntPair)chunkPair.getLeft()).field_77275_b);
                ((Runnable)chunkPair.getRight()).run();
            }
            this.chunksToLoadSlowQueue.subList(0, i).clear();
            profiler.func_76319_b();
        }
        profiler.func_76319_b();
    }

    @Override
    public boolean dropLazyChunk(int x, int z, Runnable runnable) {
        if (!ArchaicConfig.lazyChunkLoading) {
            return false;
        }
        ChunkCoordIntPair c = new ChunkCoordIntPair(x, z);
        Pair pair = Pair.of((Object)c, (Object)runnable);
        if (this.chunksToLoadSlow.contains((Object)pair)) {
            this.chunksToLoadDropQueue.add((Object)pair);
            return true;
        }
        return false;
    }
}

