/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.lighting.world.lighting;

import com.falsepattern.lib.compat.BlockPos;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.lighting.api.IChunkLighting;
import org.embeddedt.archaicfix.lighting.api.ILightingEngine;
import org.embeddedt.archaicfix.lighting.collections.PooledLongQueue;
import org.embeddedt.archaicfix.lighting.world.lighting.LightingEngineHelpers;

public class LightingEngine
implements ILightingEngine {
    private static final boolean ENABLE_ILLEGAL_THREAD_ACCESS_WARNINGS = true;
    private static final int MAX_SCHEDULED_COUNT = 0x400000;
    private static final int MAX_LIGHT = 15;
    private final Thread ownedThread = Thread.currentThread();
    private final World world;
    private final Profiler profiler;
    private final PooledLongQueue[] queuedLightUpdates = new PooledLongQueue[EnumSkyBlock.values().length];
    private final PooledLongQueue[] queuedDarkenings = new PooledLongQueue[16];
    private final PooledLongQueue[] queuedBrightenings = new PooledLongQueue[16];
    private final PooledLongQueue initialBrightenings;
    private final PooledLongQueue initialDarkenings;
    private boolean updating = false;
    private static final int lX = 26;
    private static final int lY = 8;
    private static final int lZ = 26;
    private static final int lL = 4;
    private static final int sZ = 0;
    private static final int sX = 26;
    private static final int sY = 52;
    private static final int sL = 60;
    private static final long mX = 0x3FFFFFFL;
    private static final long mY = 255L;
    private static final long mZ = 0x3FFFFFFL;
    private static final long mL = 15L;
    private static final long mPos = 0xFFFFFFFFFFFFFFFL;
    private static final long yCheck = 0x1000000000000000L;
    private static final long[] neighborShifts = new long[6];
    private static final long mChunk = 4503598620737520L;
    private final BlockPos.MutableBlockPos curPos = new BlockPos.MutableBlockPos();
    private Chunk curChunk;
    private long curChunkIdentifier;
    private long curData;
    static boolean isDynamicLightsLoaded;
    private boolean isNeighborDataValid = false;
    private final NeighborInfo[] neighborInfos = new NeighborInfo[6];
    private PooledLongQueue.LongQueueIterator queueIt;
    private final ReentrantLock lock = new ReentrantLock();
    private static int ITEMS_PROCESSED;
    private static int CHUNKS_FETCHED;

    public LightingEngine(World world) {
        int i;
        this.world = world;
        this.profiler = world.field_72984_F;
        isDynamicLightsLoaded = Loader.isModLoaded((String)"DynamicLights");
        PooledLongQueue.Pool pool = new PooledLongQueue.Pool();
        this.initialBrightenings = new PooledLongQueue(pool);
        this.initialDarkenings = new PooledLongQueue(pool);
        for (i = 0; i < EnumSkyBlock.values().length; ++i) {
            this.queuedLightUpdates[i] = new PooledLongQueue(pool);
        }
        for (i = 0; i < this.queuedDarkenings.length; ++i) {
            this.queuedDarkenings[i] = new PooledLongQueue(pool);
        }
        for (i = 0; i < this.queuedBrightenings.length; ++i) {
            this.queuedBrightenings[i] = new PooledLongQueue(pool);
        }
        for (i = 0; i < this.neighborInfos.length; ++i) {
            this.neighborInfos[i] = new NeighborInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightUpdate(EnumSkyBlock lightType, int xIn, int yIn, int zIn) {
        this.acquireLock();
        try {
            this.scheduleLightUpdate(lightType, LightingEngine.encodeWorldCoord(xIn, yIn, zIn));
        }
        finally {
            this.releaseLock();
        }
    }

    private void scheduleLightUpdate(EnumSkyBlock lightType, long pos) {
        PooledLongQueue queue = this.queuedLightUpdates[lightType.ordinal()];
        queue.add(pos);
        if (queue.size() >= 0x400000) {
            this.processLightUpdatesForType(lightType);
        }
    }

    @Override
    public void processLightUpdates() {
        this.processLightUpdatesForType(EnumSkyBlock.Sky);
        this.processLightUpdatesForType(EnumSkyBlock.Block);
    }

    @Override
    public void processLightUpdatesForType(EnumSkyBlock lightType) {
        if (this.world.field_72995_K && !this.isCallingFromMainThread()) {
            return;
        }
        PooledLongQueue queue = this.queuedLightUpdates[lightType.ordinal()];
        if (queue.isEmpty()) {
            return;
        }
        this.acquireLock();
        try {
            this.processLightUpdatesForTypeInner(lightType, queue);
        }
        finally {
            this.releaseLock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isCallingFromMainThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    private void acquireLock() {
        if (!this.lock.tryLock()) {
            Thread current = Thread.currentThread();
            if (current != this.ownedThread) {
                IllegalAccessException e = new IllegalAccessException(String.format("World is owned by '%s' (ID: %s), but was accessed from thread '%s' (ID: %s)", this.ownedThread.getName(), this.ownedThread.getId(), current.getName(), current.getId()));
                ArchaicLogger.LOGGER.warn("Something (likely another mod) has attempted to modify the world's state from the wrong thread!\nThis is *bad practice* and can cause severe issues in your game. Phosphor has done as best as it can to mitigate this violation, but it may negatively impact performance or introduce stalls.\nIn a future release, this violation may result in a hard crash instead of the current soft warning. You should report this issue to our issue tracker with the following stacktrace information.\n(If you are aware you have misbehaving mods and cannot resolve this issue, you can safely disable this warning by setting `enable_illegal_thread_access_warnings` to `false` in Phosphor's configuration file for the time being.)", (Throwable)e);
            }
            this.lock.lock();
        }
    }

    private void releaseLock() {
        this.lock.unlock();
    }

    private void processLightUpdatesForTypeInner(EnumSkyBlock lightType, PooledLongQueue queue) {
        int oldLight;
        if (this.updating) {
            throw new IllegalStateException("Already processing updates!");
        }
        this.updating = true;
        this.curChunkIdentifier = -1L;
        this.profiler.func_76320_a("lighting");
        this.profiler.func_76320_a("checking");
        this.queueIt = queue.iterator();
        while (this.nextItem()) {
            int newLight;
            if (this.curChunk == null) continue;
            oldLight = this.getCursorCachedLight(lightType);
            if (oldLight < (newLight = this.calculateNewLightFromCursor(lightType))) {
                this.initialBrightenings.add((long)newLight << 60 | this.curData);
                continue;
            }
            if (oldLight <= newLight) continue;
            this.initialDarkenings.add(this.curData);
        }
        this.queueIt = this.initialBrightenings.iterator();
        while (this.nextItem()) {
            int newLight = (int)(this.curData >> 60 & 0xFL);
            if (newLight <= this.getCursorCachedLight(lightType)) continue;
            this.enqueueBrightening((BlockPos)this.curPos, this.curData & 0xFFFFFFFFFFFFFFFL, newLight, this.curChunk, lightType);
        }
        this.queueIt = this.initialDarkenings.iterator();
        while (this.nextItem()) {
            oldLight = this.getCursorCachedLight(lightType);
            if (oldLight == 0) continue;
            this.enqueueDarkening((BlockPos)this.curPos, this.curData, oldLight, this.curChunk, lightType);
        }
        this.profiler.func_76319_b();
        for (int curLight = 15; curLight >= 0; --curLight) {
            this.profiler.func_76320_a("darkening");
            this.queueIt = this.queuedDarkenings[curLight].iterator();
            while (this.nextItem()) {
                int luminosity;
                if (this.getCursorCachedLight(lightType) >= curLight) continue;
                Block state = LightingEngineHelpers.posToState((BlockPos)this.curPos, this.curChunk);
                int opacity = (luminosity = this.getCursorLuminosity(state, lightType)) >= 14 ? 1 : this.getPosOpacity((BlockPos)this.curPos, state);
                if (this.calculateNewLightFromCursor(luminosity, opacity, lightType) < curLight) {
                    int newLight = luminosity;
                    this.fetchNeighborDataFromCursor(lightType);
                    for (NeighborInfo info : this.neighborInfos) {
                        int nLight;
                        Chunk nChunk = info.chunk;
                        if (nChunk == null || (nLight = info.light) == 0) continue;
                        BlockPos.MutableBlockPos nPos = info.pos;
                        if (curLight - this.getPosOpacity((BlockPos)nPos, LightingEngineHelpers.posToState((BlockPos)nPos, info.section)) >= nLight) {
                            this.enqueueDarkening((BlockPos)nPos, info.key, nLight, nChunk, lightType);
                            continue;
                        }
                        newLight = Math.max(newLight, nLight - opacity);
                    }
                    this.enqueueBrighteningFromCursor(newLight, lightType);
                    continue;
                }
                this.enqueueBrighteningFromCursor(curLight, lightType);
            }
            this.profiler.func_76318_c("brightening");
            this.queueIt = this.queuedBrightenings[curLight].iterator();
            while (this.nextItem()) {
                int oldLight2 = this.getCursorCachedLight(lightType);
                if (oldLight2 != curLight) continue;
                this.world.func_147479_m(this.curPos.getX(), this.curPos.getY(), this.curPos.getZ());
                if (curLight <= 1) continue;
                this.spreadLightFromCursor(curLight, lightType);
            }
            this.profiler.func_76319_b();
        }
        this.profiler.func_76319_b();
        this.updating = false;
    }

    private void fetchNeighborDataFromCursor(EnumSkyBlock lightType) {
        if (this.isNeighborDataValid) {
            return;
        }
        this.isNeighborDataValid = true;
        for (int i = 0; i < this.neighborInfos.length; ++i) {
            NeighborInfo info = this.neighborInfos[i];
            info.key = this.curData + neighborShifts[i];
            long nLongPos = info.key;
            if ((nLongPos & 0x1000000000000000L) != 0L) {
                info.chunk = null;
                info.section = null;
                continue;
            }
            BlockPos.MutableBlockPos nPos = LightingEngine.decodeWorldCoord(info.pos, nLongPos);
            Chunk nChunk = (nLongPos & 0xFFFFFC3FFFFF0L) == this.curChunkIdentifier ? (info.chunk = this.curChunk) : (info.chunk = this.getChunk((BlockPos)nPos));
            if (nChunk == null) continue;
            ExtendedBlockStorage nSection = nChunk.func_76587_i()[nPos.getY() >> 4];
            info.light = LightingEngine.getCachedLightFor(nChunk, nSection, (BlockPos)nPos, lightType);
            info.section = nSection;
        }
    }

    private static int getCachedLightFor(Chunk chunk, ExtendedBlockStorage storage, BlockPos pos, EnumSkyBlock type) {
        int i = pos.getX() & 0xF;
        int j = pos.getY();
        int k = pos.getZ() & 0xF;
        if (storage == null) {
            if (type == EnumSkyBlock.Sky && chunk.func_76619_d(i, j, k)) {
                return type.field_77198_c;
            }
            return 0;
        }
        if (type == EnumSkyBlock.Sky) {
            if (chunk.field_76637_e.field_73011_w.field_76576_e) {
                return 0;
            }
            return storage.func_76670_c(i, j & 0xF, k);
        }
        if (type == EnumSkyBlock.Block) {
            return storage.func_76674_d(i, j & 0xF, k);
        }
        return type.field_77198_c;
    }

    private int calculateNewLightFromCursor(EnumSkyBlock lightType) {
        Block state = LightingEngineHelpers.posToState((BlockPos)this.curPos, this.curChunk);
        int luminosity = this.getCursorLuminosity(state, lightType);
        int opacity = luminosity >= 14 ? 1 : this.getPosOpacity((BlockPos)this.curPos, state);
        return this.calculateNewLightFromCursor(luminosity, opacity, lightType);
    }

    private int calculateNewLightFromCursor(int luminosity, int opacity, EnumSkyBlock lightType) {
        if (luminosity >= 15 - opacity) {
            return luminosity;
        }
        int newLight = luminosity;
        this.fetchNeighborDataFromCursor(lightType);
        for (NeighborInfo info : this.neighborInfos) {
            if (info.chunk == null) continue;
            int nLight = info.light;
            newLight = Math.max(nLight - opacity, newLight);
        }
        return newLight;
    }

    private void spreadLightFromCursor(int curLight, EnumSkyBlock lightType) {
        this.fetchNeighborDataFromCursor(lightType);
        for (NeighborInfo info : this.neighborInfos) {
            int newLight;
            Chunk nChunk = info.chunk;
            if (nChunk == null || (newLight = curLight - this.getPosOpacity((BlockPos)info.pos, LightingEngineHelpers.posToState((BlockPos)info.pos, info.section))) <= info.light) continue;
            this.enqueueBrightening((BlockPos)info.pos, info.key, newLight, nChunk, lightType);
        }
    }

    private void enqueueBrighteningFromCursor(int newLight, EnumSkyBlock lightType) {
        this.enqueueBrightening((BlockPos)this.curPos, this.curData, newLight, this.curChunk, lightType);
    }

    private void enqueueBrightening(BlockPos pos, long longPos, int newLight, Chunk chunk, EnumSkyBlock lightType) {
        this.queuedBrightenings[newLight].add(longPos);
        chunk.func_76633_a(lightType, pos.getX() & 0xF, pos.getY(), pos.getZ() & 0xF, newLight);
    }

    private void enqueueDarkening(BlockPos pos, long longPos, int oldLight, Chunk chunk, EnumSkyBlock lightType) {
        this.queuedDarkenings[oldLight].add(longPos);
        chunk.func_76633_a(lightType, pos.getX() & 0xF, pos.getY(), pos.getZ() & 0xF, 0);
    }

    private static BlockPos.MutableBlockPos decodeWorldCoord(BlockPos.MutableBlockPos pos, long longPos) {
        int posX = (int)(longPos >> 26 & 0x3FFFFFFL) - 0x2000000;
        int posY = (int)(longPos >> 52 & 0xFFL);
        int posZ = (int)(longPos >> 0 & 0x3FFFFFFL) - 0x2000000;
        return pos.setPos(posX, posY, posZ);
    }

    private static long encodeWorldCoord(long x, long y, long z) {
        return y << 52 | x + 0x2000000L << 26 | z + 0x2000000L << 0;
    }

    private boolean nextItem() {
        if (!this.queueIt.hasNext()) {
            this.queueIt.finish();
            this.queueIt = null;
            return false;
        }
        this.curData = this.queueIt.next();
        this.isNeighborDataValid = false;
        LightingEngine.decodeWorldCoord(this.curPos, this.curData);
        long chunkIdentifier = this.curData & 0xFFFFFC3FFFFF0L;
        if (this.curChunkIdentifier != chunkIdentifier) {
            this.curChunk = this.getChunk((BlockPos)this.curPos);
            this.curChunkIdentifier = chunkIdentifier;
            ++CHUNKS_FETCHED;
        }
        ++ITEMS_PROCESSED;
        return true;
    }

    private int getCursorCachedLight(EnumSkyBlock lightType) {
        return ((IChunkLighting)this.curChunk).getCachedLightFor(lightType, this.curPos.getX(), this.curPos.getY(), this.curPos.getZ());
    }

    private int getCursorLuminosity(Block state, EnumSkyBlock lightType) {
        if (lightType == EnumSkyBlock.Sky) {
            if (this.curChunk.func_76619_d(this.curPos.getX() & 0xF, this.curPos.getY(), this.curPos.getZ() & 0xF)) {
                return EnumSkyBlock.Sky.field_77198_c;
            }
            return 0;
        }
        return MathHelper.func_76125_a((int)LightingEngineHelpers.getLightValueForState(state, (IBlockAccess)this.world, this.curPos.getX(), this.curPos.getY(), this.curPos.getZ()), (int)0, (int)15);
    }

    private int getPosOpacity(BlockPos pos, Block state) {
        return MathHelper.func_76125_a((int)state.getLightOpacity((IBlockAccess)this.world, pos.getX(), pos.getY(), pos.getZ()), (int)1, (int)15);
    }

    private Chunk getChunk(BlockPos pos) {
        IChunkProvider prov = this.world.func_72863_F();
        int chunkX = pos.getX() >> 4;
        int chunkZ = pos.getZ() >> 4;
        return LightingEngineHelpers.getLoadedChunk(prov, chunkX, chunkZ);
    }

    static {
        EnumFacing[] values = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
        for (int i = 0; i < 6; ++i) {
            LightingEngine.neighborShifts[i] = (long)values[i].func_96559_d() << 52 | (long)values[i].func_82601_c() << 26 | (long)values[i].func_82599_e() << 0;
        }
        ITEMS_PROCESSED = 0;
        CHUNKS_FETCHED = 0;
    }

    private static class NeighborInfo {
        Chunk chunk;
        ExtendedBlockStorage section;
        int light;
        long key;
        final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

        private NeighborInfo() {
        }
    }
}

